#! /bin/sh

# $Id: proftpd.sh,v 1.3 2003/05/19 18:28:52 jt Exp $

# Define constants.
user=18
group=544
sys=`uname`
nt=`expr ${sys} : CYGWIN_NT`
export CYGWIN=ntsec

# Create proftpd config file with correct ownership and permissions,
# if necessary.
configFile=/etc/proftpd.conf

if [ ! -f $configFile ]
then
	cp -p $configFile.default $configFile
	if [ $nt -ne 0 ]
	then
		chown $user:$group $configFile
		chmod 644 $configFile
	fi
fi

# Create proftpd /var directory with correct ownership and permissions,
# if necessary.
varDir=/var/proftpd

if [ ! -d $varDir ]
then
	mkdir $varDir

	if [ $nt -ne 0 ]
	then
		chown $user:$group $varDir
		chmod 755 $varDir
	fi
fi
